/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalents2;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class DogRespawnStorage
extends WorldSavedData {
    private Map<UUID, DogRespawnData> respawnDataMap = Maps.newConcurrentMap();

    public DogRespawnStorage() {
        super("doggytalentsDeadDogs");
    }

    public static DogRespawnStorage get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Tried to access dog respawn data from the client. This should not happen...");
        }
        ServerWorld overworld = world.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (DogRespawnStorage)storage.func_215752_a(DogRespawnStorage::new, "doggytalentsDeadDogs");
    }

    public Stream<DogRespawnData> getDogs(@Nonnull UUID ownerId) {
        return this.respawnDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<DogRespawnData> getDogs(@Nonnull String ownerName) {
        return this.respawnDataMap.values().stream().filter(data -> ownerName.equals(data.getOwnerName()));
    }

    @Nullable
    public DogRespawnData getData(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            return this.respawnDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogRespawnData remove(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            DogRespawnData storage = this.respawnDataMap.remove(uuid);
            this.func_76185_a();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogRespawnData putData(DogEntity dogIn) {
        UUID uuid = dogIn.func_110124_au();
        DogRespawnData storage = new DogRespawnData(this, uuid);
        storage.populate(dogIn);
        this.respawnDataMap.put(uuid, storage);
        this.func_76185_a();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.respawnDataMap.keySet());
    }

    public Collection<DogRespawnData> getAll() {
        return Collections.unmodifiableCollection(this.respawnDataMap.values());
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.respawnDataMap.clear();
        ListNBT list = nbt.func_150295_c("respawnData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT respawnCompound = list.func_150305_b(i);
            UUID uuid = NBTUtil.getUniqueId(respawnCompound, "uuid");
            DogRespawnData respawnData = new DogRespawnData(this, uuid);
            respawnData.read(respawnCompound);
            if (uuid == null) {
                DoggyTalents2.LOGGER.info("Failed to load dog respawn data. Please report to mod author...");
                DoggyTalents2.LOGGER.info((Object)respawnData);
                continue;
            }
            this.respawnDataMap.put(uuid, respawnData);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, DogRespawnData> entry : this.respawnDataMap.entrySet()) {
            CompoundNBT respawnCompound = new CompoundNBT();
            DogRespawnData respawnData = entry.getValue();
            NBTUtil.putUniqueId(respawnCompound, "uuid", entry.getKey());
            respawnData.write(respawnCompound);
            list.add((Object)respawnCompound);
        }
        compound.func_218657_a("respawnData", (INBT)list);
        return compound;
    }
}

